<?php

namespace App\Modules\Machupicchu\Domain\Availability;

class Availability
{
    public function __construct(
        private AvailabilityCapacity $capacity,
        private AvailabilityDay $day,
        private AvailabilityAvailable $availability,
        private AvailabilityDate $date,
        private AvailabilityDatePrint $datePrint,
        private AvailabilityHoliDay $holiday,
        private AvailabilityRoute $route
    ) {
    }

    public function capacity(): AvailabilityCapacity
    {
        return $this->capacity;
    }
    public function day(): AvailabilityDay
    {
        return $this->day;
    }
    public function availability(): AvailabilityAvailable
    {
        return $this->availability;
    }
    public function date(): AvailabilityDate
    {
        return $this->date;
    }
    public function datePrint(): AvailabilityDatePrint
    {
        return $this->datePrint;
    }
    public function holiday(): AvailabilityHoliDay
    {
        return $this->holiday;
    }
    public function route(): AvailabilityRoute
    {
        return $this->route;
    }
}
