<?php

namespace App\Modules\LeadPassenger\Application\Update;

use App\Modules\LeadPassenger\Application\Update\LeadPassengerUpdaterResponse;
use App\Modules\LeadPassenger\Domain\LeadPassenger;
use App\Modules\LeadPassenger\Domain\LeadPassengerRepository;

final class LeadPassengerUpdater
{
    public function __construct(private LeadPassengerRepository $repository)
    {
    }

    public function __invoke(LeadPassenger $leadPassenger): LeadPassengerUpdaterResponse
    {
        return new LeadPassengerUpdaterResponse($this->repository->update($leadPassenger));
    }
}
