<?php

namespace App\Modules\LeadBookingTour\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class LeadBookingTourUpdaterQuery implements Query
{
    public function __construct(
        private string $id,
        private string $dateStart,
        private string $pickUp,
        private int $type,
        private int $noPax,
        private int $status
    ) {
    }

    public function getId(): string
    {
        return $this->id;
    }
    public function getDateStart(): string
    {
        return $this->dateStart;
    }
    public function getPickUp(): string
    {
        return $this->pickUp;
    }
    public function getType(): int
    {
        return $this->type;
    }
    public function getNoPax(): int
    {
        return $this->noPax;
    }
    public function getStatus(): int
    {
        return $this->status;
    }
}
