<?php

namespace App\Modules\LeadBookingTour\Application\Index;

use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingTourIndexerQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingTourIndexer $inserter)
    {
    }

    public function __invoke(LeadBookingTourIndexerQuery $query): LeadBookingTourIndexerResponse
    {
        return $this->inserter->__invoke(new IdLeadBookingTour($query->getId()));
    }
}
