<?php

namespace App\Modules\LeadBookingTour\Application\GroupList;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourGroup;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingTourGroupListerQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingTourGroupLister $inserter)
    {
    }

    public function __invoke(LeadBookingTourGroupListerQuery $query): LeadBookingTourGroupListerResponse
    {
        return $this->inserter->__invoke(
            new IdLeadBooking($query->idLeadBooking()),
            new LeadBookingTourGroup($query->group()),
            $query->action()
        );
    }
}
