<?php

namespace App\Modules\LeadBookingServicePassenger\Infraestructure;

use App\Modules\LeadBookingService\Domain\IdLeadBookingService;
use App\Modules\LeadBookingServicePassenger\Domain\LeadBookingServicePassenger;
use App\Modules\LeadBookingServicePassenger\Domain\LeadBookingServicePassengerRepository;
use App\Modules\LeadBookingServicePassenger\Domain\IdLeadBookingServicePassenger;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlLeadBookingServicePassengerRepository implements LeadBookingServicePassengerRepository
{

    public function find(IdLeadBookingService $idLeadBookingService, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_lead_booking_service_passenger_list(?,?,@sts,@cod,@msg)',
            [
                $idLeadBookingService->value(),
                $action
            ]
        );
    }

    public function index(IdLeadBookingServicePassenger $id)
    {
        return Requester::requestSelect(
            'CALL sp_lead_booking_service_passenger_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(LeadBookingServicePassenger $value)
    {
        return Requester::requestInsert(
            'CALL sp_lead_booking_service_passenger_insert(?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getStatus()->value(),
                $value->getIdLeadBookingService()->value(),
                $value->getIdLeadBookingTourPassenger()->value(),
            ]
        );
    }

    public function update(LeadBookingServicePassenger $value)
    {
        return Requester::requestUpdate(
            'CALL sp_lead_booking_service_passenger_update(?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getStatus()->value()
            ]
        );
    }

    public function delete(IdLeadBookingServicePassenger $id)
    {
        return Requester::requestUpdate(
            'CALL sp_lead_booking_service_passenger_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
