<?php

namespace App\Modules\LeadBookingService\Application\Update;

use App\Modules\LeadBookingService\Application\Update\LeadBookingServiceUpdaterResponse;
use App\Modules\LeadBookingService\Domain\LeadBookingService;
use App\Modules\LeadBookingService\Domain\LeadBookingServiceRepository;

final class LeadBookingServiceUpdater
{
    public function __construct(private LeadBookingServiceRepository $repository)
    {
    }

    public function __invoke(LeadBookingService $leadBookingService): LeadBookingServiceUpdaterResponse
    {
        return new LeadBookingServiceUpdaterResponse($this->repository->update($leadBookingService));
    }
}
