<?php

namespace App\Modules\LeadBooking\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class LeadBookingInserterQuery implements Query
{
    public function __construct(
        private string $leadBookingObservation,
        private int $leadBookingContact,
        private int $leadBookingStatus,
        private int $idGuideLanguage,
        private int $idLanguage,
        private int $idLead,
        private string $token
    ) {
    }

    public function getObservation(): string
    {
        return $this->leadBookingObservation;
    }
    public function getContact(): int
    {
        return $this->leadBookingContact;
    }
    public function getStatus(): int
    {
        return $this->leadBookingStatus;
    }
    public function getIdGuideLanguage(): int
    {
        return $this->idGuideLanguage;
    }
    public function getIdLanguage(): int
    {
        return $this->idLanguage;
    }
    public function getIdLead(): int
    {
        return $this->idLead;
    }
    public function token(): string
    {
        return $this->token;
    }
}
