<?php

namespace App\Modules\Lead\Application\CreateOrUpdate;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class LeadInsertOrUpdaterQuery implements Query
{
    public function __construct(
        private int $idLead,
        private string $leadName,
        private string $leadLastName,
        private string $leadEmail,
        private string $leadPhoneCode,
        private string $leadPhone,
        private int $idTypeDocument,
        private int $idUserCountry,
    ) {
    }

    public function id(): int
    {
        return $this->idLead;
    }
    public function name(): string
    {
        return $this->leadName;
    }
    public function lastName(): string
    {
        return $this->leadLastName;
    }
    public function email(): string
    {
        return $this->leadEmail;
    }
    public function phoneCode(): string
    {
        return $this->leadPhoneCode;
    }
    public function phone(): string
    {
        return $this->leadPhone;
    }
    public function noDocument(): string
    {
        return $this->leadNoDocument;
    }
    public function idTypeDocument(): int
    {
        return $this->idTypeDocument;
    }
    public function idUserCountry(): int
    {
        return $this->idUserCountry;
    }
}
