<?php

namespace App\Modules\Invoice\Infrastructure;

use App\Modules\Invoice\Domain\InvoiceRepository;
use App\Modules\Invoice\Domain\Invoice;
use App\Modules\Invoice\Domain\IdInvoice;
use App\Modules\Shared\Application\SelectHandler;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlInvoiceRepository implements InvoiceRepository
{

    public function index(IdInvoice $id)
    {
        return (new SelectHandler())->handle(
            DB::select(
                'CALL sp_invoice_get(?)',
                [
                    $id->value(),
                ]
            )
        );
    }
}
