<?php

namespace App\Modules\Image\Application;

use App\Modules\Image\Domain\ImagePath;
use App\Modules\Image\Domain\ImageRepository;
use App\Modules\Shared\Domain\RequestAction;
use App\Modules\Shared\Validator\Domain\ListInput;

class ImageListing {

    private ImageRepository $repository;

    public function __construct(
        ImageRepository $repository
    ) {
        $this->repository = $repository;
    }

    public function __invoke (RequestAction $action, ListInput $listInput, ImagePath $imagePath) {
        return $this->repository->list($action, $listInput, $imagePath);
    }
}