<?php

namespace App\Modules\Image\Application;

use App\Modules\Language\Domain\IdLanguage;
use App\Modules\Image\Domain\Image;
use App\Modules\Image\Domain\ImageRepository;
use App\Modules\Image\Domain\IdImage;
use App\Modules\Image\Domain\ImagePath;
use App\Modules\Shared\Application\WrapperResponse;
use Throwable;

class ImageDeleter {

    private ImageRepository $repository;

    public function __construct(
        ImageRepository $repository
    ) {
        $this->repository = $repository;
    }

    public function __invoke (
        IdImage $id,
        IdLanguage $idLanguage,
        ImagePath $imagePath,
        ImageIndexer $imageIndexer
    ):WrapperResponse {
        
        $albumDetail = $imageIndexer->__invoke($id, $idLanguage, $imagePath);
        $wrapper = $this->repository->remove($id, $idLanguage);
        if ($albumDetail != null) {
            try {
                unlink($albumDetail->albumdetail_url_path);
            } catch (Throwable $th) {}
        }
        return $wrapper;
    }
}