<?php

namespace App\Modules\HtlUsage\Domain;

class HtlUsage {

    private HtlUsageDateUsage $dateUsage;
    private HtlUsageStatus $status;
    private HtlUsageLock $lock;
    private HtlUsageName $name;
    private HtlUsageLastName $lastName;
    private HtlUsageRemark $remark;
    private HUIdHtlRoom $idHtlRoom;
    private ?IdHtlUsage $id;


    /** constructor */
    public function __construct (
        HtlUsageDateUsage $dateUsage,
        HtlUsageStatus $status,
        HtlUsageLock $lock,
        HtlUsageName $name,
        HtlUsageLastName $lastName,
        HtlUsageRemark $remark,
        HUIdHtlRoom $idHtlRoom,
        ?IdHtlUsage $id = NULL
    ) {
        $this->dateUsage = $dateUsage;
        $this->status = $status;
        $this->lock = $lock;
        $this->name = $name;
        $this->lastName = $lastName;
        $this->remark = $remark;
        $this->idHtlRoom = $idHtlRoom;
        $this->id = $id;
    }

    public function getDateUsage():HtlUsageDateUsage { return $this->dateUsage; }
    public function getStatus():HtlUsageStatus { return $this->status; }
    public function getLock():HtlUsageLock { return $this->lock; }
    public function getName():HtlUsageName { return $this->name; }
    public function getLastName():HtlUsageLastName { return $this->lastName; }
    public function getRemark():HtlUsageRemark { return $this->remark; }
    public function getIdHtlRoom():HUIdHtlRoom { return $this->idHtlRoom; }
    public function getId():IdHtlUsage { return $this->id; }

}