<?php

namespace App\Modules\HtlTypeRoom\Application\Index;

use App\Modules\HtlTypeRoom\Domain\IdHtlTypeRoom;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoomRepository;
use App\Modules\HtlTypeRoom\Domain\IndexHtlTypeRoom;

final class HtlTypeRoomIndexer
{
    public function __construct(private HtlTypeRoomRepository $repository)
    {
    }

    public function __invoke(IdHtlTypeRoom $idHtlTypeRoom, bool $lockInShare = false)
    {
        $index = $this->repository->find(new IndexHtlTypeRoom($idHtlTypeRoom, $lockInShare));
        return $index;
    }
}
