<?php

namespace App\Modules\HtlTypeRoom\Application\Delete;

use App\Modules\HtlTypeRoom\Domain\IdHtlTypeRoom;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoom;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoomAbrv;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoomName;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoomStatus;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoomType;
use App\Modules\HtlTypeRoom\Domain\Id;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlRoom\Domain\IdHtlRoom;
use App\Modules\HtlTypeRoom\Application\Index\HtlTypeRoomIndexer;
use App\Modules\HtlTypeRoom\Application\Update\HtlTypeRoomUpdater;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteHtlTypeRoomQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlTypeRoomUpdater $update,
        private HtlTypeRoomIndexer $indexer
    ) {
    }

    public function __invoke(DeleteHtlTypeRoomQuery $query): DeleteHtlTypeRoomResponse
    {
        $index = $this->indexer->__invoke(new IdHtlTypeRoom($query->idHtlTypeRoom()), true);
        $index->delete();
        $this->update->__invoke($index);
        return new DeleteHtlTypeRoomResponse();
    }
}
