<?php

namespace App\Modules\HtlTypeRoom\Application\Create;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\HtlTypeRoom\Domain\IdHtlTypeRoom;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoom;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoomAbrv;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoomName;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoomStatus;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoomType;
use App\Modules\HtlTypeRoom\Domain\Id;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateHtlTypeRoomQueryHandler implements QueryHandler
{
    public function __construct(private HtlTypeRoomCreator $creator)
    {
    }

    public function __invoke(CreateHtlTypeRoomQuery $query): CreateHtlTypeRoomResponse
    {
        $model = new HtlTypeRoom(
            new IdHtlTypeRoom(0),
            new HtlTypeRoomName($query->name()),
            new HtlTypeRoomAbrv($query->abrv()),
            new HtlTypeRoomStatus($query->status()),
            new IdHtlCamp($query->idHtlCamp()),
        );
        return new CreateHtlTypeRoomResponse($this->creator->__invoke($model));
    }
}
