<?php

namespace App\Modules\HtlTypeCamp\Domain;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListHtlTypeCamp implements StorageCriteria
{

    public function __construct(
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlTypeCamp::select('`ftd`');
        if ($this->action == 'all') {
            $where = '`ftd`.`HtlTypeCamp_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`ftd`.`HtlTypeCamp_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`ftd`.`HtlTypeCamp_Status` = 0';
        } else {
            $where = '`ftd`.`HtlTypeCamp_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_htl_type_camp` `ftd`
            WHERE $where",
            []
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
