<?php

namespace App\Modules\HtlTypeCamp\Application\Delete;

use App\Modules\HtlTypeCamp\Domain\IdHtlTypeCamp;
use App\Modules\HtlTypeCamp\Domain\HtlTypeCamp;
use App\Modules\HtlTypeCamp\Domain\HtlTypeCampAbrv;
use App\Modules\HtlTypeCamp\Domain\HtlTypeCampName;
use App\Modules\HtlTypeCamp\Domain\HtlTypeCampStatus;
use App\Modules\HtlTypeCamp\Domain\HtlTypeCampType;
use App\Modules\HtlTypeCamp\Domain\Id;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlTypeCamp\Application\Index\HtlTypeCampIndexer;
use App\Modules\HtlTypeCamp\Application\Update\HtlTypeCampUpdater;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteHtlTypeCampQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlTypeCampUpdater $update,
        private HtlTypeCampIndexer $indexer
    ) {
    }

    public function __invoke(DeleteHtlTypeCampQuery $query): DeleteHtlTypeCampResponse
    {
        $index = $this->indexer->__invoke(new IdHtlTypeCamp($query->idHtlTypeCamp()), true);
        $index->delete();
        $this->update->__invoke($index);
        return new DeleteHtlTypeCampResponse();
    }
}
