<?php

namespace App\Modules\HtlTypeCamp\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateHtlTypeCampQuery implements Query
{
    public function __construct(
        private string $name,
        private string $abrv,
        private int $status,
    ) {
    }

    public function name(): string
    {
        return $this->name;
    }

    public function abrv(): string
    {
        return $this->abrv;
    }

    public function status(): int
    {
        return $this->status;
    }
}
