<?php

namespace App\Modules\HtlRoom\Application\UpdateAvailability;

use App\Modules\HtlBed\Application\Index\HtlBedIndexer;
use App\Modules\HtlBed\Domain\HtlBedAvailability;
use App\Modules\HtlBed\Domain\IdHtlBed;
use App\Modules\HtlBed\Domain\HtlBedDescription;
use App\Modules\HtlBed\Domain\HtlBedName;
use App\Modules\HtlBed\Domain\HtlBedStatus;
use App\Modules\HtlRoom\Domain\IdHtlRoom;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateAvailabilityHtlRoomQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlRoomAvailabilityUpdater $updater
    ) {
    }

    public function __invoke(UpdateAvailabilityHtlRoomQuery $query): UpdateAvailabilityHtlRoomResponse
    {
        $this->updater->__invoke(new IdHtlRoom($query->id()));
        return new UpdateAvailabilityHtlRoomResponse();
    }
}
