<?php

namespace App\Modules\HtlRoom\Application\UpdateAvailability;

use App\Modules\HtlBed\Application\ListFromTypeRoom\ListFromTypeRoomHtlBedQuery;
use App\Modules\HtlBed\Domain\HtlBed;
use App\Modules\HtlRoom\Application\HtlRoomIndexer;
use App\Modules\HtlRoom\Domain\HtlRoom;
use App\Modules\HtlRoom\Domain\HtlRoomAvailability;
use App\Modules\HtlRoom\Domain\HtlRoomRepository;
use App\Modules\HtlRoom\Domain\IdHtlRoom;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

final class HtlRoomAvailabilityUpdater
{
    public function __construct(
        private HtlRoomRepository $repository,
        private HtlRoomIndexer $indexer,
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(IdHtlRoom $idHtlRoom)
    {
        $response = $this->indexer->__invoke($idHtlRoom, true)['Response_Data'][0];
        $query = new ListFromTypeRoomHtlBedQuery($response->Id_HtlTypeRoom, 'active');
        /** @var HtlBedResponses $htlBeds */
        $htlBeds = $this->queryBus->ask($query);
        $availability = array_reduce($htlBeds->data(), fn($last, HtlBed $bed) => $last + $bed->availability()->value(), 0);
        return $this->repository->updateAvailability($idHtlRoom, new HtlRoomAvailability($availability));
    }
}
