<?php

namespace App\Modules\HtlCampSchedule\Application\ChangeUsage;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ChangeUsageHtlCampScheduleQuery implements Query
{
    public function __construct(
        private int $idHtlCamp,
        private string $date,
        private int $amountBefore,
        private int $amountAfter
    ) {
    }

    public function getIdHtlCamp(): int
    {
        return $this->idHtlCamp;
    }

    public function getDate(): string
    {
        return $this->date;
    }

    public function getAmountBefore(): int
    {
        return $this->amountBefore;
    }

    public function getAmountAfter(): int
    {
        return $this->amountAfter;
    }
}
