<?php

namespace App\Modules\HtlCampLock\Application\Update;

use App\Modules\HtlCampLock\Application\Index\HtlCampLockIndexer;
use App\Modules\HtlCampLock\Domain\HtlCampLockAmount;
use App\Modules\HtlCampLock\Domain\IdHtlCampLock;
use App\Modules\HtlCampLock\Domain\HtlCampLockDate;
use App\Modules\HtlCampLock\Domain\HtlCampLockDateStart;
use App\Modules\HtlCampLock\Domain\HtlCampLockLock;
use App\Modules\HtlCampLock\Domain\HtlCampLockRemark;
use App\Modules\HtlCampLock\Domain\HtlCampLockStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateHtlCampLockQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlCampLockUpdater $updater,
        private HtlCampLockIndexer $indexer
    ) {
    }

    public function __invoke(UpdateHtlCampLockQuery $query): UpdateHtlCampLockResponse
    {
        $index = $this->indexer->__invoke(new IdHtlCampLock($query->id()), true);
        $lastDateStart = $index->dateStart();
        $index->setRemark(new HtlCampLockRemark($query->remark()));
        if (!$index->isLocked()) {
            $index->setDateStart(new HtlCampLockDateStart($query->dateStart()));
            $index->setStatus(new HtlCampLockStatus($query->status()));
        }

        $this->updater->__invoke($index);
        return new UpdateHtlCampLockResponse();
    }
}
