<?php

namespace App\Modules\HtlCampLock\Application\List;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\HtlCampLock\Application\HtlCampLockResponse;
use App\Modules\HtlCampLock\Application\HtlCampLockResponses;
use App\Modules\HtlCampLock\Domain\HtlCampLock;
use App\Modules\HtlCampLock\Domain\ListHtlCampLockModel;
use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListHtlCampLockQueryHandler implements QueryHandler
{
    public function __construct(private HtlCampLockLister $lister)
    {
    }

    public function __invoke(ListHtlCampLockQuery $query): HtlCampLockResponses
    {
        return new HtlCampLockResponses(...array_map(
            fn (HtlCampLock $index) => new HtlCampLockResponse(
                $index->id()->value(),
                $index->date()->value(),
                $index->dateStart()->value(),
                $index->amount()->value(),
                $index->status()->value(),
                $index->idHtlCampSchedule()->value(),
            ),
            $this->lister->__invoke(new IdHtlCampSchedule($query->getIdHtlCampSchedule()), $query->getAction())
        ));
    }
}
