<?php

namespace App\Modules\HtlCampLock\Application\List;

use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\HtlCampLock\Domain\HtlCampLockRepository;
use App\Modules\HtlCampLock\Domain\ListHtlCampLock;

final class HtlCampLockLister
{
    public function __construct(private HtlCampLockRepository $repository)
    {
    }

    public function __invoke(IdHtlCampSchedule $idHtlCampSchedule, string $action)
    {
        return $this->repository->search(new ListHtlCampLock($idHtlCampSchedule, $action));
    }
}
