<?php

namespace App\Modules\HtlCampLock\Application\CreateByTour;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateByTourHtlCampLockQuery implements Query
{
    public function __construct(
        private int $idTour,
        private string $dateStart,
        private int $passengerAmount,
    ) {
    }

    public function idTour(): int
    {
        return $this->idTour;
    }
    public function dateStart(): string
    {
        return $this->dateStart;
    }

    public function passengerAmount(): int
    {
        return $this->passengerAmount;
    }
}
