<?php

namespace App\Modules\HtlCampBookingPassenger\Domain;

use App\Modules\HtlCampBooking\Domain\IdHtlCampBooking;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListHtlCampBookingPassenger implements StorageCriteria
{

    public function __construct(
        private IdHtlCampBooking $idHtlCampBooking,
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlCampBookingPassenger::select('`hcbp`');
        if ($this->action == 'all') {
            $where = '`hcbp`.`HtlCampBookingPassenger_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`hcbp`.`HtlCampBookingPassenger_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`hcbp`.`HtlCampBookingPassenger_Status` = 0';
        } else {
            $where = '`hcbp`.`HtlCampBookingPassenger_Status` = 2';
        }
        return DB::select(
            "SELECT $select,
                `btp`.`BookingTourPassenger_Status`,
                `p`.`Passenger_Name`,
                `p`.`Passenger_LastName`,
                `p`.`Passenger_Order`
            FROM `t_htl_camp_booking_passenger` `hcbp`
            INNER JOIN `t_booking_tour_passenger` `btp` ON `btp`.`Id_BookingTourPassenger` = `hcbp`.`Id_BookingTourPassenger`
            INNER JOIN `t_passenger` `p` ON `p`.`Id_Passenger` = `btp`.`Id_Passenger`
            WHERE `hcbp`.`Id_HtlCampBooking` = ?
            AND $where
            ORDER BY `p`.`Passenger_Order` ASC,
            `hcbp`.`Id_HtlCampBookingPassenger` ASC",
            [$this->idHtlCampBooking->value()]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
