<?php

namespace App\Modules\HtlCampBookingPassenger\Application\Delete;

use App\Modules\HtlCampBookingPassenger\Domain\IdHtlCampBookingPassenger;
use App\Modules\HtlCampBookingPassenger\Application\Index\HtlCampBookingPassengerIndexer;
use App\Modules\HtlCampBookingPassenger\Application\Update\HtlCampBookingPassengerUpdater;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteHtlCampBookingPassengerQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlCampBookingPassengerUpdater $update,
        private HtlCampBookingPassengerIndexer $indexer,
    ) {
    }

    public function __invoke(DeleteHtlCampBookingPassengerQuery $query): DeleteHtlCampBookingPassengerResponse
    {
        $index = $this->indexer->__invoke(new IdHtlCampBookingPassenger($query->idHtlCampBookingPassenger()), true);
        $index->delete();
        $this->update->__invoke($index);
        return new DeleteHtlCampBookingPassengerResponse();
    }
}
