<?php

namespace App\Modules\HtlCampBooking\Infrastructure;

use App\Modules\HtlCampBooking\Domain\HtlCampBooking;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingRepository;
use App\Modules\HtlCampBooking\Domain\ListHtlCampBookingModel;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\DBRequester;

class MysqlHtlCampBookingRepository implements HtlCampBookingRepository
{

    public function find(StorageCriteria $criteria): HtlCampBooking | null
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return HtlCampBooking::fromDTO($data);
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn($btp) => ListHtlCampBookingModel::fromDTO($btp), $criteria->run());
    }

    public function insert(HtlCampBooking $value)
    {
        return DBRequester::requestInsert($value);
    }

    public function update(HtlCampBooking $value)
    {
        return DBRequester::requestUpdate($value);
    }
}
