<?php

namespace App\Modules\HtlCampBooking\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ExistsHtlCampBooking implements StorageCriteria
{

    public function __construct(
        private IdHtlCampBooking $id,
        private bool $lockInShare = false
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlCampBooking::select('`hcb`');

        return DB::select(
            "SELECT $select
            FROM `t_htl_camp_booking` `hcb`
            WHERE `hcb`.`Id_HtlCampBooking` = ?",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new HtlCampBookingNotFound();
        }
        return $data[0];
    }
}
