<?php

namespace App\Modules\HtlBed\Infrastructure;

use App\Modules\HtlBed\Domain\HtlBed;
use App\Modules\HtlBed\Domain\HtlBedRepository;
use App\Modules\HtlBed\Domain\IdHtlBed;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\DBRequester;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlHtlBedRepository implements HtlBedRepository
{

    public function find(StorageCriteria $criteria): HtlBed | null
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return HtlBed::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn($btp) => HtlBed::fromDTO($btp), $criteria->run());
    }

    public function insert(HtlBed $value)
    {
        return DBRequester::requestInsert($value);
    }

    public function update(HtlBed $value)
    {
        return DBRequester::requestUpdate($value);
    }

    public function delete(IdHtlBed $id)
    {
        return Requester::requestUpdate(
            'CALL sp_htl_bed_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
