<?php

namespace App\Modules\HtlBed\Application\Update;

use App\Modules\HtlBed\Application\Index\HtlBedIndexer;
use App\Modules\HtlBed\Domain\HtlBedAvailability;
use App\Modules\HtlBed\Domain\IdHtlBed;
use App\Modules\HtlBed\Domain\HtlBedDescription;
use App\Modules\HtlBed\Domain\HtlBedName;
use App\Modules\HtlBed\Domain\HtlBedStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateHtlBedQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlBedUpdater $updater,
        private HtlBedIndexer $indexer
    ) {
    }

    public function __invoke(UpdateHtlBedQuery $query): UpdateHtlBedResponse
    {
        $index = $this->indexer->__invoke(new IdHtlBed($query->id()), true);
        $index->setName(new HtlBedName($query->name()));
        $index->setDescription(new HtlBedDescription($query->description()));
        $index->setAvailability(new HtlBedAvailability($query->availability()));
        $index->setStatus(new HtlBedStatus($query->status()));
        $this->updater->__invoke($index);
        return new UpdateHtlBedResponse();
    }
}
