<?php

namespace App\Modules\HtlBed\Application\ListFromTypeRoom;

use App\Modules\HtlBed\Application\HtlBedResponse;
use App\Modules\HtlBed\Application\HtlBedResponses;
use App\Modules\HtlBed\Domain\HtlBed;
use App\Modules\HtlTypeRoom\Domain\IdHtlTypeRoom;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListFromTypeRoomHtlBedQueryHandler implements QueryHandler
{
    public function __construct(private HtlBedFromTypeRoomLister $lister)
    {
    }

    public function __invoke(ListFromTypeRoomHtlBedQuery $query): HtlBedResponses
    {
        return new HtlBedResponses(...array_map(
            fn (HtlBed $index) => new HtlBedResponse(
                $index->id()->value(),
                $index->name()->value(),
                $index->description()->value(),
                $index->availability()->value(),
                $index->status()->value(),
                $index->idHtlCamp()->value(),
            ),
            $this->lister->__invoke(new IdHtlTypeRoom($query->getIdHtlTypeRoom()), $query->getAction())
        ));
    }
}
