<?php

namespace App\Modules\History\Application\ListCount;

use App\Modules\History\Domain\IdHistoryReference;
use App\Modules\HistoryTable\Domain\IdHistoryTable;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

final class ListCountHistoryQueryHandler implements QueryHandler
{
    public function __construct(private HistoryListCounter $counter)
    {
    }

    public function __invoke(ListCountHistoryQuery $query): ListCountHistoryResponse
    {
        $count = $this->counter->__invoke(
            new DateStart($query->dateStart()),
            new DateEnd($query->dateEnd()),
            new IdHistoryTable($query->getIdHistoryTable()),
            new IdHistoryReference($query->getIdReference()),
            $query->getAction()
        );
        return new ListCountHistoryResponse($count);
    }
}
