<?php

namespace App\Modules\GroupProviderReview\Application\List;

use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class GroupProviderReviewListerQueryHandler implements QueryHandler
{
    public function __construct(private GroupProviderReviewLister $lister)
    {
    }

    public function __invoke(GroupProviderReviewListerQuery $query): GroupProviderReviewListerResponse
    {
        return $this->lister->__invoke(
            new IdGroupProvider($query->idGroupProvider()),
            $query->getAction()
        );
    }
}
