<?php

namespace App\Modules\GroupProviderReview\Application;

use App\Modules\GroupProviderReview\Domain\GroupProviderReviewRepository;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

class GroupProviderReviewFinder
{

    private GroupProviderReviewRepository $repository;

    public function __construct(GroupProviderReviewRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke($action, DateStart $dateStart, DateEnd $dateEnd)
    {
        return $this->repository->find($action, $dateStart, $dateEnd);
    }
}
