<?php

namespace App\Modules\GroupProviderMedia\Infrastructure;

use App\Modules\GroupProviderMedia\Domain\GroupProviderMedia;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaRepository;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\DBRequester;

class MysqlGroupProviderMediaRepository implements GroupProviderMediaRepository
{

    public function find(StorageCriteria $criteria): GroupProviderMedia | null
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return GroupProviderMedia::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn ($btp) => GroupProviderMedia::fromDTO($btp), $criteria->run());
    }

    public function insert(GroupProviderMedia $value)
    {
        return DBRequester::requestInsert($value);
    }

    public function update(GroupProviderMedia $value)
    {
        return DBRequester::requestUpdate($value);
    }
}
