<?php

namespace App\Modules\GroupProviderMedia\Domain;

use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class GroupProviderMedia extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdGroupProviderMedia::class, 'Id_GroupProviderMedia', 'primary'),
            new AggregateAttribute('path', GroupProviderMediaPath::class, 'GroupProviderMedia_Path'),
            new AggregateAttribute('pathThumb', GroupProviderMediaPathThumb::class, 'GroupProviderMedia_Path_Thumb'),
            new AggregateAttribute('pathLargeThumb', GroupProviderMediaPathLargeThumb::class, 'GroupProviderMedia_Path_LargeThumb'),
            new AggregateAttribute('description', GroupProviderMediaDescription::class, 'GroupProviderMedia_Description'),
            new AggregateAttribute('extension', GroupProviderMediaExtension::class, 'GroupProviderMedia_Extension'),
            new AggregateAttribute('size', GroupProviderMediaSize::class, 'GroupProviderMedia_Size'),
            new AggregateAttribute('type', GroupProviderMediaType::class, 'GroupProviderMedia_Type'),
            new AggregateAttribute('hasThumbnail', GroupProviderMediaHasThumbnail::class, 'GroupProviderMedia_HasThumbnail'),
            new AggregateAttribute('error', GroupProviderMediaError::class, 'GroupProviderMedia_Error'),
            new AggregateAttribute('status', GroupProviderMediaStatus::class, 'GroupProviderMedia_Status'),
            new AggregateAttribute('idGroupProvider', IdGroupProvider::class, 'Id_GroupProvider'),
        ];
    }

    protected static function table(): string
    {
        return 't_group_provider_media';
    }

    public function __construct(
        protected IdGroupProviderMedia $id,
        protected GroupProviderMediaPath $path,
        protected GroupProviderMediaPathThumb $pathThumb,
        protected GroupProviderMediaPathLargeThumb $pathLargeThumb,
        protected GroupProviderMediaDescription $description,
        protected GroupProviderMediaExtension $extension,
        protected GroupProviderMediaSize $size,
        protected GroupProviderMediaType $type,
        protected GroupProviderMediaHasThumbnail $hasThumbnail,
        protected GroupProviderMediaError $error,
        protected GroupProviderMediaStatus $status,
        protected IdGroupProvider $idGroupProvider,
    ) {
    }

    public function id(): IdGroupProviderMedia
    {
        return $this->id;
    }
    public function path(): GroupProviderMediaPath
    {
        return $this->path;
    }

    public function pathThumb(): GroupProviderMediaPathThumb
    {
        return $this->pathThumb;
    }

    public function pathLargeThumb(): GroupProviderMediaPathLargeThumb
    {
        return $this->pathLargeThumb;
    }

    public function description(): GroupProviderMediaDescription
    {
        return $this->description;
    }

    public function extension(): GroupProviderMediaExtension
    {
        return $this->extension;
    }

    public function size(): GroupProviderMediaSize
    {
        return $this->size;
    }

    public function type(): GroupProviderMediaType
    {
        return $this->type;
    }

    public function hasThumbnail(): GroupProviderMediaHasThumbnail
    {
        return $this->hasThumbnail;
    }

    public function error(): GroupProviderMediaError
    {
        return $this->error;
    }

    public function status(): GroupProviderMediaStatus
    {
        return $this->status;
    }

    public function idGroupProvider(): IdGroupProvider
    {
        return $this->idGroupProvider;
    }


    public function setPath(GroupProviderMediaPath $path): void
    {
        $this->path = $path;
    }

    public function setPathThumb(GroupProviderMediaPathThumb $pathThumb): void
    {
        $this->pathThumb = $pathThumb;
    }

    public function setPathLargeThumb(GroupProviderMediaPathLargeThumb $pathLargeThumb): void
    {
        $this->pathLargeThumb = $pathLargeThumb;
    }

    public function setExtension(GroupProviderMediaExtension $extension): void
    {
        $this->extension = $extension;
    }

    public function setSize(GroupProviderMediaSize $size): void
    {
        $this->size = $size;
    }

    public function setType(GroupProviderMediaType $type): void
    {
        $this->type = $type;
    }

    public function setError(GroupProviderMediaError $error): void
    {
        $this->error = $error;
    }

    public function setStatus(GroupProviderMediaStatus $status): void
    {
        $this->status = $status;
    }

    public function delete()
    {
        $this->status = new GroupProviderMediaStatus(GroupProviderMediaStatus::DELETED);
    }
}
