<?php

namespace App\Modules\GroupProvider\Domain;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

/**
 * @extends StorageCriteria<GroupProvider>
 */
class ListGroupProvider implements StorageCriteria
{

    public function __construct(
        private IdGroup $idGroup
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = GroupProvider::select('`ftd`');
        return DB::select(
            "SELECT $select
            FROM " . GroupProvider::table() . " `ftd`
            WHERE Id_Group = ? ",
            [$this->idGroup->value()]
        );
    }

    protected function analize($data)
    {
        return array_map(fn ($data) => GroupProvider::fromDTO($data), $data);
    }
}
