<?php

namespace App\Modules\GroupProvider\Domain;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

/**
 * @extends StorageCriteria<GroupProvider>
 */
class ListForDeleteGroupProvider implements StorageCriteria
{

    public function __construct()
    {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = GroupProvider::select('`ftd`');
        return DB::select(
            "SELECT $select
            FROM " . GroupProvider::table() . " `ftd`
            WHERE `GroupProvider_MediaStatus` = ?",
            [GroupProviderMediaStatus::DOWNLOADED]
        );
    }

    protected function analize($data)
    {
        return array_map(fn ($data) => GroupProvider::fromDTO($data), $data);
    }
}
