<?php

namespace App\Modules\GroupProvider\Application\UpdateMediaScore;

use App\Modules\GroupProvider\Domain\GroupProviderMediaScore;
use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateMediaScoreGroupProviderQueryHandler implements QueryHandler
{
    public function __construct(
        private MediaScoreGroupProviderUpdater $reviewer
    ) {
    }

    public function __invoke(UpdateMediaScoreGroupProviderQuery $query): UpdateMediaScoreGroupProviderResponse
    {
        $this->reviewer->__invoke(
            new IdGroupProvider($query->id()),
            new GroupProviderMediaScore($query->mediaScore())
        );
        return new UpdateMediaScoreGroupProviderResponse();
    }
}
