<?php

namespace App\Modules\GroupProvider\Application\List;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupProvider\Domain\GroupProviderRepository;
use App\Modules\GroupProvider\Domain\ListGroupProvider;

class GroupProviderLister
{

    private GroupProviderRepository $repository;

    public function __construct(GroupProviderRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(IdGroup $id)
    {
        return $this->repository->search(new ListGroupProvider($id));
    }
}
