<?php

namespace App\Modules\GroupPassengerMedia\Application\List;

use App\Modules\GroupPassengerMedia\Application\GroupPassengerMediaResponse;
use App\Modules\GroupPassengerMedia\Application\GroupPassengerMediaResponses;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListGroupPassengerMediaQueryHandler implements QueryHandler
{
    public function __construct(private GroupPassengerMediaLister $lister)
    {
    }

    public function __invoke(ListGroupPassengerMediaQuery $query): GroupPassengerMediaResponses
    {
        return new GroupPassengerMediaResponses(...array_map(
            fn ($index) => new GroupPassengerMediaResponse(
                $index->id()->value(),
                $index->path()->value(),
                $index->pathThumb()->value(),
                $index->pathLargeThumb()->value(),
                $index->description()->value(),
                $index->extension()->value(),
                $index->size()->value(),
                $index->type()->value(),
                $index->hasThumbnail()->value(),
                $index->error()->value(),
                $index->status()->value(),
                $index->idGroupPassenger()->value(),
            ),
            $this->lister->__invoke(new IdGroupPassenger($query->idGroupPassenger()), $query->getAction())
        ));
    }
}
