<?php

namespace App\Modules\GroupPassengerMedia\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateGroupPassengerMediaQuery implements Query
{
    public function __construct(
        private string $path,
        private string $pathThumb,
        private string $pathLargeThumb,
        private string $description,
        private string $extension,
        private int $size,
        private int $type,
        private int $hasThumbnail,
        private string $error,
        private int $status,
        private int $idGroupPassenger,
    ) {
    }

    public function path(): string
    {
        return $this->path;
    }

    public function pathThumb(): string
    {
        return $this->pathThumb;
    }

    public function pathLargeThumb(): string
    {
        return $this->pathLargeThumb;
    }

    public function description(): string
    {
        return $this->description;
    }

    public function extension(): string
    {
        return $this->extension;
    }

    public function size(): int
    {
        return $this->size;
    }

    public function type(): int
    {
        return $this->type;
    }

    public function hasThumbnail(): int
    {
        return $this->hasThumbnail;
    }

    public function error(): string
    {
        return $this->error;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function idGroupPassenger(): int
    {
        return $this->idGroupPassenger;
    }
}
