<?php

namespace App\Modules\GroupPassenger\Application\UpdateStatus;

use App\Modules\GroupPassenger\Domain\GroupPassengerMediaStatus;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateStatusGroupPassengerQueryHandler implements QueryHandler
{
    public function __construct(
        private StatusGroupPassengerUpdater $reviewer
    ) {
    }

    public function __invoke(UpdateStatusGroupPassengerQuery $query): UpdateStatusGroupPassengerResponse
    {
        $this->reviewer->__invoke(
            new IdGroupPassenger($query->id()),
            new GroupPassengerMediaStatus($query->mediaStatus())
        );
        return new UpdateStatusGroupPassengerResponse();
    }
}
