<?php

namespace App\Modules\GroupPassenger\Application\Update;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupPassenger\Domain\GroupPassenger;
use App\Modules\GroupPassenger\Domain\GroupPassengerExternalReview;
use App\Modules\GroupPassenger\Domain\GroupPassengerIdAlter;
use App\Modules\GroupPassenger\Domain\GroupPassengerNotification;
use App\Modules\GroupPassenger\Domain\GroupPassengerNotificationAccepted;
use App\Modules\GroupPassenger\Domain\GroupPassengerReviewDateUpdate;
use App\Modules\GroupPassenger\Domain\GroupPassengerReviewStatus;
use App\Modules\GroupPassenger\Domain\GroupPassengerType;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateGroupPassengerQueryHandler implements QueryHandler
{
    public function __construct(private GroupPassengerUpdater $inserter)
    {
    }

    public function __invoke(UpdateGroupPassengerQuery $query): UpdateGroupPassengerResponse
    {
        $model = new GroupPassenger(
            new IdGroupPassenger($query->id()),
            new GroupPassengerType($query->type()),
            new GroupPassengerNotification($query->notification()),
            new GroupPassengerNotificationAccepted($query->notificationAccepted()),
            new GroupPassengerExternalReview($query->externalReview()),
            new GroupPassengerReviewStatus($query->reviewStatus()),
            new GroupPassengerReviewDateUpdate($query->reviewDateUpdate()),
            new IdGroup($query->idGroup()),
            new GroupPassengerIdAlter($query->idAlter()),
        );
        return $this->inserter->__invoke($model);
    }
}
