<?php

namespace App\Modules\GroupPassenger\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class UpdateGroupPassengerQuery implements Query
{
    public function __construct(
        private int $id,
        private int $type,
        private int $notification,
        private int $notificationAccepted,
        private int $externalReview,
        private int $reviewStatus,
        private string $reviewDateUpdate,
        private int $idGroup,
        private int $idAlter,
    ) {
    }

    public function id(): int
    {
        return $this->id;
    }

    public function type(): int
    {
        return $this->type;
    }

    public function notification(): int
    {
        return $this->notification;
    }

    public function notificationAccepted(): int
    {
        return $this->notificationAccepted;
    }

    public function externalReview(): int
    {
        return $this->externalReview;
    }

    public function reviewStatus(): int
    {
        return $this->reviewStatus;
    }

    public function reviewDateUpdate(): string
    {
        return $this->reviewDateUpdate;
    }

    public function idGroup(): int
    {
        return $this->idGroup;
    }

    public function idAlter(): int
    {
        return $this->idAlter;
    }

}
