<?php

namespace App\Modules\GroupPassenger\Application\ReportCategorized;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ReportCategorizedGroupPassengerQuery implements Query
{
    public function __construct(
        private string $dateStart,
        private string $dateEnd,
    ) {
    }

    public function dateStart(): string
    {
        return $this->dateStart;
    }

    public function dateEnd(): string
    {
        return $this->dateEnd;
    }
}
