<?php

namespace App\Modules\GroupPassenger\Application\Report;

use App\Modules\Group\Domain\GroupDateEnd;
use App\Modules\Group\Domain\GroupDateStart;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ReportGroupPassengerQueryHandler implements QueryHandler
{
    public function __construct(private GroupPassengerReporter $update)
    {
    }

    public function __invoke(ReportGroupPassengerQuery $query): ReportGroupPassengerResponse
    {
        return $this->update->__invoke(
            new GroupDateStart($query->dateStart()),
            new GroupDateEnd($query->dateEnd())
        );
    }
}
