<?php

namespace App\Modules\GroupPassenger\Application\ListGallery;

use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\QueryList\QueryPaginate;

final class ListGalleryGroupPassengerQueryHandler implements QueryHandler
{
    public function __construct(private GalleryGroupPassengerLister $lister)
    {
    }

    public function __invoke(ListGalleryGroupPassengerQuery $query)
    {
        return new ListGalleryGroupPassengerResponses(...array_map(
            fn ($index) => new ListGalleryGroupPassengerResponse(
                $index->Id_GroupPassenger,
                $index->GroupPassenger_Type,
                $index->GroupPassenger_Notification,
                $index->GroupPassenger_NotificationAccepted,
                $index->GroupPassenger_ExternalReview,
                $index->GroupPassenger_ReviewStatus,
                $index->GroupPassenger_ReviewDateUpdate,
                $index->GroupPassenger_MediaDateUpdate,
                $index->GroupPassenger_MediaStatus,
                $index->GroupPassenger_MediaScore,
                $index->GroupPassenger_MediaScoreDescription,
                $index->Id_Group,
                $index->Id_BookingTourPassenger,
                new ListGalleryGroupPassengerResponsePassenger(
                    $index->Passenger_DateCreate,
                    $index->Passenger_DateEdit,
                    $index->Passenger_Name,
                    $index->Passenger_LastName,
                    $index->Passenger_Email,
                    $index->Passenger_Phone,
                    $index->Passenger_PhoneCode,
                    $index->Passenger_Gender,
                    $index->Passenger_DOB,
                    $index->Passenger_NoDocument,
                    $index->Passenger_DateEntrance,
                    $index->Passenger_Restriction,
                    $index->Passenger_Extras,
                    $index->Passenger_Order,
                    $index->Passenger_ImgDocument1,
                    $index->Passenger_ImgDocument2,
                    $index->Passenger_Reportable,
                    $index->Passenger_Status,
                    $index->Passenger_PaymentStatus,
                    $index->Passenger_InfoStatus,
                    $index->Passenger_CheckedInStatus,
                    $index->Passenger_ConfirmMessage,
                    $index->Passenger_Full,
                    $index->Id_Booking,
                    $index->Id_TypeDocument,
                    $index->Id_UserCountry,
                    $index->Id_TypeRate,
                ),
                new ListGalleryGroupPassengerResponseGroup(
                    $index->Group_Date,
                    $index->Group_DateUpdate,
                    $index->Group_DateStart,
                    $index->Group_DateEnd,
                    $index->Group_Hour,
                    $index->Group_Name,
                    $index->Group_Token,
                    $index->Group_Origin,
                    $index->Group_Destination,
                    $index->Group_Type,
                    $index->Group_Order,
                    $index->Group_TourDuration,
                    $index->Group_Remark,
                    $index->Group_MasterType,
                    $index->Group_ServiceType,
                    $index->Group_NoValidPassengers,
                    $index->Group_ValidPassengers,
                    $index->Group_Status,
                    $index->Id_Master,
                    $index->Id_Service,
                    $index->Id_StatusGroup,
                    $index->Id_Tour === null ? null : new ListGalleryGroupPassengerResponseTour(
                        $index->Id_Tour,
                        $index->Tour_Code,
                        $index->Tour_Name,
                        $index->Tour_UrlThumbnail,
                        $index->Tour_Duration,
                        $index->Tour_MinPax,
                        $index->Tour_Availability,
                        $index->Tour_AvailabilityStatus,
                        $index->Tour_Anticipation,
                        $index->Tour_AnticipationType,
                        $index->Tour_Color,
                        $index->Tour_Score,
                        $index->Tour_ScoreCant,
                        $index->Tour_ScoreTotal,
                        $index->Tour_Status,
                        $index->Id_CategoryTour,
                        $index->Id_TypeTour,
                        $index->Id_Country,
                        $index->Id_State,
                        $index->Id_City,
                    )
                ),
                new ListGalleryGroupPassengerResponseBooking(
                    $index->Booking_Date,
                    $index->Booking_Code,
                )
            ),
            $this->lister->__invoke(
                $query->dateStart(),
                $query->dateEnd(),
                $query->search(),
                $query->action(),
                QueryPaginate::fromData($query->page(), $query->pageSize()),
            )
        ));
    }
}
